/* $Id: hwc.c,v 1.5 1999/03/10 01:20:26 ericb Exp $ */
/* Copyright (C) 1999, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef	WIN32
#include <unistd.h>
#endif
#include "hpe1432.h"

#define	NMOD_MAX	4
#define	NCHAN_MAX	(NMOD_MAX * 16)

static const volatile char rcsid[] =
"@(#)$Id: hwc.c,v 1.5 1999/03/10 01:20:26 ericb Exp $";
static const char *progname;

#ifdef	TEST_CALLBACK
/*ARGSUSED*/
static void _VI_FUNCH
callback1(ViInt32 value, ViInt32 reason)
{
}

/*ARGSUSED*/
static void _VI_FUNCH
callback2(ViInt32 value, ViInt32 reason)
{
}
#endif

static int
test(int verbose)
{
    ViSession session = 0;
    ViStatus vierr;
    ViReal64 min, max, def, step;
    ViInt32 laddr[NMOD_MAX];
    ViInt32 hwc[27 * NMOD_MAX];
    ViInt32 chans[NCHAN_MAX];
    ViInt32 i, group, nmod, nchan;
    char    rsrc[NMOD_MAX * 4 + 16];
    char    msg[256];

    /* Look for E143x modules */
    if (verbose)
	(void) printf("hpe1432_find\n");
    vierr = hpe1432_find(0, laddr, NMOD_MAX, &nmod, rsrc, NMOD_MAX * 4 + 16);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_find: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }
    if (verbose)
    {
	(void) printf("Found %d modules:", nmod);
	for (i = 0; i < nmod; i++)
	    (void) printf(" %ld", laddr[i]);
	(void) printf("\n");
	(void) printf("Initial resource string: %s\n", rsrc);
    }

    /* Create resource string */
    if (verbose)
	(void) printf("Creating resource string\n");
    (void) sprintf(rsrc + strlen(rsrc), "::");
    for (i = 0; i < nmod; i++)
    {
	(void) sprintf(rsrc + strlen(rsrc), "%ld", laddr[i]);
	if (i < nmod - 1)
	    (void) sprintf(rsrc + strlen(rsrc), ",");
    }
    (void) sprintf(rsrc + strlen(rsrc), "::INSTR");
    if (verbose)
	(void) printf("Resource string: %s\n", rsrc);

    /* Initialize hpe1432 library */
    if (verbose)
	(void) printf("hpe1432_init\n");
    vierr = hpe1432_init(rsrc, 0, 1, &session);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_init: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }

    /* Get hardware configuration */
    if (verbose)
	(void) printf("hpe1432_getHWConfig\n");
    vierr = hpe1432_getHWConfig(session, nmod, laddr, hwc);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_getHWConfig: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }

    if (verbose)
	for (i = 0; i < nmod; i++)
	{
	    (void) printf("Config for LA %ld:\n", laddr[i]);
	    (void) printf("Model code:  0x%lx\n", hwc[i * 27 + 1]);
	    (void) printf("HW Rev:      %ld\n", hwc[i * 27 + 2]);
	    (void) printf("Bootrom Rev: %ld\n", hwc[i * 27 + 3]);
	    (void) printf("FW Rev:      %ld\n", hwc[i * 27 + 4]);
	    (void) printf("Input Chans: %ld\n", hwc[i * 27 + 21]);
	    (void) printf("Src Chans:   %ld\n", hwc[i * 27 + 22]);
	    (void) printf("Tach Chans:  %ld\n", hwc[i * 27 + 23]);
	}

    /* Check span limits */
    if (verbose)
	(void) printf("hpe1432_getSpanLimits\n");
    vierr = hpe1432_getSpanLimits(session, 1, &min, &max, &def, &step);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_getSpanLimits: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }
    if (verbose)
	(void) printf("Span min %g max %g def %g step %g\n",
		      min, max, def, step);

#ifdef	TEST_CALLBACK
    /* Set up callback routine */
    if (verbose)
	(void) printf("hpe1432_callbackInstall 1\n");
    vierr = hpe1432_callbackInstall(session, 1, callback1, 0);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_callbackInstall: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }
    if (verbose)
	(void) printf("hpe1432_callbackInstall NULL\n");
    vierr = hpe1432_callbackInstall(session, 1, NULL, 0);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_callbackInstall: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }
    /* Switch to different callback routine */
    if (verbose)
	(void) printf("hpe1432_callbackInstall 2\n");
    vierr = hpe1432_callbackInstall(session, 1, callback2, 0);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_callbackInstall: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }
    if (verbose)
	(void) printf("hpe1432_callbackInstall NULL\n");
    vierr = hpe1432_callbackInstall(session, 1, NULL, 0);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr, "%s: hpe1432_callbackInstall: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }
#endif	/* TEST_CALLBACK */

    if (verbose)
	(void) printf("hpe1432_createChannelGroup loop:\n");
    chans[0] = 1;
    for (i = 0; i < 1000; i++)
    {
	if (verbose)
	{
	    (void) printf(" %3ld", i);
	    if ((i % 20) == 19)
		(void) printf("\n");
	}
	vierr = hpe1432_createChannelGroup(session, 1, chans, &group);
	if (vierr)
	{
	    (void) hpe1432_error_message(session, vierr, msg);
	    (void) fprintf(stderr, "%s: hpe1432_createChannelGroup: returned %d = %s\n",
			   progname, vierr, msg);
	    return -1;
	}
	/* Because I know the internals of the hpe1432 library, I know
	   that the first channel group created gets an ID of -1.
	   Check for that, and print a message if it is ever different
	   from that. */
	if (group != -1)
	    (void) printf("group %ld?\n", group);
	vierr = hpe1432_deleteChannelGroup(session, group);
	if (vierr)
	{
	    (void) hpe1432_error_message(session, vierr, msg);
	    (void) fprintf(stderr, "%s: hpe1432_deleteChannelGroup: returned %d = %s\n",
			   progname, vierr, msg);
	    return -1;
	}
    }
    if ((i % 20) != 0)
	(void) printf("\n");

    nchan = 0;
    for (i = 0; i < nmod; i++)
	nchan += hwc[i * 27 + 21];
    for (i = 0; i < nchan; i++)
	chans[i] = i + 1;
    if (verbose)
	(void) printf("hpe1432_createChannelGroup\n");
    vierr = hpe1432_createChannelGroup(session, nchan, chans, &group);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr,
		       "%s: hpe1432_createChannelGroup: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }
    if (verbose)
	(void) printf("hpe1432_autoRange\n");
    vierr = hpe1432_autoRange(session, group, 0);
    if (vierr)
    {
	(void) hpe1432_error_message(session, vierr, msg);
	(void) fprintf(stderr,
		       "%s: hpe1432_autoRange: returned %d = %s\n",
		       progname, vierr, msg);
	return -1;
    }

    if (verbose)
	(void) printf("done\n");

    return 0;
}

static void
usage(void)
{
    (void) fprintf(stderr,
		   "Usage: %s [-uvV]\n"
		   "\t-u: Print this usage message\n"
		   "\t-v: Verbose output\n"
		   "\t-V: Print version info\n",
		   progname);
    exit(2);
}

int
main(int argc, char **argv)
{
    int     verbose;
#ifndef	WIN32
    int     c;
#endif

    /* Get program name */
    progname = strrchr(argv[0], '/');
    if (progname == NULL)
	progname = argv[0];
    else
	progname++;

    /* Set option defaults */
    verbose = 0;

#ifndef	WIN32
    /* Process command-line options */
    while ((c = getopt(argc, argv, "uvV")) != -1)
	switch (c)
	{
	case 'v':
	    verbose++;
	    break;
	case 'V':
	    (void) printf("%s\n", rcsid);
	    exit(EXIT_SUCCESS);
	case 'u':
	default:
	    usage();
	}

    if (argc > optind)
    {
	(void) fprintf(stderr, "%s: extra command-line arguments\n",
		       progname);
	usage();
    }
#else
    verbose = 1;
#endif

    if (test(verbose) < 0)
	return EXIT_FAILURE;

    return EXIT_SUCCESS;
}
